


*#########################################################################
*START CODE
*#########################################################################


use "C:\Users\...\ITEMSdata.dta", clear //use your own path here


*#########################################################################
*#########################################################################
*VISUALIZE/UNDERSTAND THE DATA
*#########################################################################
*#########################################################################


*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*GET DESCRIPTIVES FOR ITEM RESPONSES AND TIMES
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

su v* //this will provide means/SDs and counts for any variable beginning with v
su v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v1_rt v2_rt v3_rt v4_rt v5_rt v6_rt v7_rt v8_rt v9_rt v10_rt

*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*VISUALIZE RESPONSE TIME DISTRIBUTIONS
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

cd "C:\Users\jgs8e\Dropbox\papersNWEA\ITEMS\code\junk\" //Change directory to save multiple graphs that will get combined

forval i = 1/10 { //loop through all 10 items

hist v`i'_rt , title("Item `i'") xtitle("Resp. Time Sec.") frac ylabel(0 [.05] .4) yscale(range(0 [.05] .4) )
	//the above line produces histograms of the RTs for item i

graph save "g`i'", replace 
	//save the graph

}

graph combine "g1" "g2" "g3" "g4" "g5" "g6" "g7" "g8" "g9" "g10" //combine the group to visualize



*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*PLOT DURATION AND PROP CORRECT BY BIN
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

cap drop bin* // remove any variable starting with "bin" in case re-running this code

forval i = 1/10 {
xtile bin`i' = v`i'_rt , nq(100) //loop through items, create percentiles of RT
}

forval i = 1/10 {
preserve //preserve the original data
collapse v`i', by(bin`i' ) // this creates means of the item responses by RT percentile

twoway (scatter v`i' bin`i') (lpoly v`i' bin`i' ) ///
 , title("Item `i'") ytitle("Resp. Time Percentile") ytitle("Prop Correct by Percentile") legend(off) ///
 ylabel(0 [.2] 1) yscale(range(0 [.2] 1) )
 
 //The above graph plots the mean item response against the percentile for RT 
 
graph save "g`i'", replace //save for later use

restore // restore data to what it was when preserve command invoked
}

graph combine "g1" "g2" "g3" "g4" "g5" "g6" "g7" "g8" "g9" "g10" , altshrink // combine graphs



*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*PLOT DIFFICULTY VERSUS DURATION
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

preserve

gen y = 1 // create a variable with all values = 1
collapse v*, by(y) // shortcut to reduce all item responses and RTs down to their means

forval i = 1/10 {
rename v`i'_rt rtv`i' // rename variables to reshape the data
}

reshape long v rtv, i(y) j(item) //reshape the data long such that scatterplots can be made

twoway (scatter v rtv) (qfit v rtv), ///
xtitle("Resp. Time") ytitle("Prop. Correct") legend(off) // plot prop correct v. RT

restore



*#########################################################################
*#########################################################################
*SET THRESHOLDS
*#########################################################################
*#########################################################################

*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*NT10
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
forval i = 1/10 {
su v`i'_rt, detail // get details on the RT distributions
loc p10 = r(p10) // identify the 10th percentile
gen NT10_v`i' = . // create an empty threshold var for item i
replace NT10_v`i' = 1 if  v`i'_rt < `p10' & v`i'_rt < 10 //replace 1 if at or below 10th ptile
replace NT10_v`i' = 0 if NT10_v`i' ==. & v`i'_rt !=. // repalce 0 if above 10th ptile
}

su NT10*



*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*NT25
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
forval i = 1/10 {
cap drop NT25_v`i'
su v`i'_rt, detail
loc p25 = r(p25)
di `p25'
gen NT25_v`i' = .
replace NT25_v`i' = 1 if  v`i'_rt < `p25' & v`i'_rt < 25
replace NT25_v`i' = 0 if NT25_v`i' ==. & v`i'_rt !=.
}

su NT10*
su NT25*


*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*CUMP
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

preserve

tempname memhold //create a temporary file to store CUMP results
tempfile results
postfile `memhold' item time cump using `results' // create names of vars to save

forval i = 1/10 { //loop through items
forval s = 1/100 { //loop through durations in second increments

qui su v`i' if v`i'_rt < `s' | v`i'_rt == `s' //get mean prop correct if RT at or below s
loc m  = r(mean) //create local to save that prop
post `memhold' (`i') (`s') (`m')  // save results

	}
}

postclose `memhold' //close temporary file
use `results', clear //save temporary file


forval i = 1/10 {
twoway (scatter cump time) (lpoly cump time) if item == `i' , ///
yline(.25)  title("Item `i'") ytitle("Cumu. Pct. Correct") xtitle("Time") ///
 ylabel(0 [.2] 1) yscale(range(0 [.2] 1) ) legend(off)
 
 //scatter cumulative prop correct against duration
 
graph save "g`i'", replace //save for later use

}


graph combine "g1" "g2" "g3" "g4" "g5" "g6" "g7" "g8" "g9" "g10" , altshrink // combine graphs

restore



*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*MLN
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

forval i = 1/1 { // for simplicity, just loop through single item
*fmm 1: regress v`i'_rt //mixture model with one class
*estat ic //get fit stats
fmm 2: regress v`i'_rt //mixture model with two classes
estat ic //get fit stats

}



*#########################################################################
*#########################################################################
*PRODUCE SCORES AND COMPARE
*#########################################################################
*#########################################################################

*original estimate
gsem (Ab -> v1-v10), logit var(Ab@1) //this is an SEM version of a 2PL model
predict Ab, latent //get a score using empirical Bayes shrinkage

*NT10
gen id = _n //creates an id equal to the row number so we can match scores back together

preserve
forval i = 1/10 {
replace v`i' = . if NT10_v`i' ==1 //replace item response as missing if rapid
}

gsem (Ab -> v1-v10), logit var(Ab@1) //fit 2PL to new data
predict Ab_NT10, latent //get new score

tempfile nt10
save `nt10' //these two lines save the new scores in a temporary file

restore


*NT25
preserve
forval i = 1/10 {
replace v`i' = . if NT25_v`i' ==1 //replace item response as missing if rapid
}

gsem (Ab -> v1-v10), logit var(Ab@1) //fit 2PL to new data
predict Ab_NT25, latent //get new score

tempfile nt25
save `nt25' //these two lines save the new scores in a temporary file

restore

merge 1:1 id using `nt10' // these next three lines merge together the original score and NT score files
drop _merge
merge 1:1 id using `nt25'

twoway (scatter Ab_NT25 Ab) (qfit Ab_NT25 Ab), legend(off) xtitle("Orig.") ytitle("NT25")
twoway (scatter Ab_NT10 Ab) (qfit Ab_NT10 Ab), legend(off) xtitle("Orig.") ytitle("NT10")
