## 1. Load packages 
library(mirt)  
# Install 'flirt' package by downloading the source file from the link: 
# https://sites.google.com/site/arbormj/sofware/flirt
# install.packages("flirt_1.15.tar.gz", type="source", repos=NULL, header = F, quiet = T) 
library(flirt)

## 2. Read in simulated data
data <- read.csv("simdata.csv", header = F)
names(data) <- paste("Item", 1:ncol(data), sep = "")
head(data)

## 3. Recode item responses 
# Define mapping matrix based on the specified tree structure
mapping <- matrix(c(0, 0, 1, 1, 
                    1, 0, NA, NA, 
                    NA, NA, 0, 1), 4, 3)
mapping

# Transform observed item responses into pseudo-item responses 
pseudo <- dendrify2(data, mapping, wide=T)[-1] #remove the first column containing person indicator
pseudo[1:2, ]

## 4. Fit an IRTree model
# Specify a model 
erstree <- mirt.model('F1 = 1-15
                      ERS = 16-45') 

# Fit the specified MIRT model to pseudo-item response data
erstree.fit <- mirt(pseudo, erstree, itemtype = "2PL", method = "MHRM", verbose = F)
erstree.fit

## 5. Print and interpret output
# Extract item parameter estimates
coef(erstree.fit, simplify = T)

# Extract person parameter estimates
fscores(erstree.fit)

## 6. Model comparison
# Specify another model assuming distinct ERS factors for the second and third nodes
erstree2 <- mirt.model('F1 = 1-15
                    ERS1 = 16-30
                    ERS2 = 31-45
                    COV = ERS1*ERS2')

# Fit the specified MIRT model to pseudo-item response data
erstree2.fit <- mirt(pseudo, erstree2, itemtype = "2PL", method = "MHRM", verbose = F)
erstree2.fit

# Extract item parameter estimates
coef(erstree2.fit,  simplify = T)

# Extract person parameter estimates
fscores(erstree2.fit)

# Model fit comparison
anova(erstree.fit, erstree2.fit)






