# 0 Load data and dependencies --------------------------------------------

library(RCurl) # for extracting data from web
library(dplyr) # for data manipulation
library(tidyr) # for pivoting data
library(lavaan) # for SEM
library(lme4) # for MLMs
library(nlme) # for MLMs
library(performance) # for ICCs

data <- read.csv(text = getURL("https://raw.githubusercontent.com/flh3/pubdata/main/MLCFA/raw.csv")) %>% 
  rename(schoolID = sid) %>% 
  mutate(teacherID = 1:nrow(.))

data_t <- data %>% 
  pivot_longer(
    cols = starts_with("x"),
    names_to = "item",
    names_prefix = "x",
    values_to = "response"
  ) %>% 
  mutate(
    x1 = ifelse(item == 1, 1, 0),
    x2 = ifelse(item == 2, 1, 0),
    x3 = ifelse(item == 3, 1, 0),
    x4 = ifelse(item == 4, 1, 0),
    x5 = ifelse(item == 5, 1, 0),
    x6 = ifelse(item == 6, 1, 0)
  ) %>% 
  select(response, x1:x6, item, teacherID, schoolID)

# 1 ICCs ------------------------------------------------------------------

# nlme

null_nlme <- lme(
  response ~ 1,
  data = data_t,
  method = "REML",
  random = ~ 1 | schoolID/teacherID/item,
  control = lmeControl(optimizer = "Nelder-Mead")
)
summary(null_nlme)

# conditional
conditional_nlme <- lme(
  response ~ 0 + x1 + x2 + x3 + x4 + x5 + x6,
  data = data_t,
  method = "REML",
  random = ~ 1 | schoolID/teacherID/item,
  control = lmeControl(optimizer = "Nelder-Mead")
)
summary(conditional_nlme)

# L2 unconditional ICC
0.60**2/(0.60**2 + 0.41**2 + 0.80**2)

# L2 conditional ICC
0.64**2/(0.64**2 + 0.42**2 + 0.36**2)

# L3 unconditional ICC
0.41**2/(0.60**2 + 0.41**2 + 0.80**2)

# L3 conditional ICC
0.42**2/(0.64**2 + 0.42**2 + 0.36**2)

# 2 MLMM ------------------------------------------------------------------

mlmm <- lme(
  response ~ 0 + x1 + x2 + x3 + x4 + x5 + x6,
  data = data_t,
  random = ~ 1 | schoolID/teacherID/item,
  weights = varIdent(form = ~ 1 | item)
)
summary(mlmm)

# level-1 variance components
(c(1.000, coef(mlmm$modelStruct$varStruct, unconstrained = FALSE))*mlmm$sigma)^2

# level-2 error variance (teacher-level student engagement factor variance)
0.638**2

# level-3 error variance (school-level student engagement factor variance)
0.418**2
