# 0 Load dependencies and data --------------------------------------------

library(lavaan)
library(lavaanPlot)

data <- read.csv("sim_cfa.csv")

# 1 CFA -------------------------------------------------------------------

model <- '
          # Item loadings
          ANX =~ NA*a1 + a2 + a3 + a4
          DEP =~ NA*d1 + d2 + d3
          
          # Factor co/variances
          ANX ~~ 1*ANX
          DEP ~~ 1*DEP
          ANX ~~ DEP
'

model_cfa <- cfa(model, data)

summary(model_cfa, fit.measures = TRUE, standardized = TRUE)

# Unit loading identification

model <- '
          # Item loadings
          ANX =~ a1 + a2 + a3 + a4
          DEP =~ d1 + d2 + d3
          
          # Factor co/variances
          ANX ~~ ANX
          DEP ~~ DEP
          ANX ~~ DEP
'

model_cfa <- cfa(model, data)

summary(model_cfa, fit.measures = TRUE, standardized = TRUE)

# Plot

lavaanPlot(model = model_cfa,
           node_options = list(shape = "box", fontname = "Helvetica"),
           edge_options = list(color = "black"),
           coefs = TRUE,
           covs = TRUE,
           stars = TRUE)
