# package install, if needed
install.packages("lme4")

# Load dependency
library(lme4)

# Read data
hoffman2007 <- read.csv("hoffman2007.csv")

# Run model
model <- lmer(logRT ~ 1 + c_sal + age + (1 + c_sal|id),
              data = hoffman2007,
              REML = FALSE)

# Print output
summary(model)

# Three-level MLM
model3 <- lmer(logRT ~ 1 + (1|id) _ (1|class),
               data = hoffman2007,
               REML = FALSE)
summary(model3)



